<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Galerie</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap" rel="stylesheet">

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Playfair+Display:ital,wght@0,400..900;1,400..900&display=swap" rel="stylesheet">

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

<meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<style>
    body{
        margin:0;
        padding:0;
        background-color:#f5efe2;
        width:100%;
        height:100vh;
        background-image:url('images/back2.png');
        background-size:cover;
        background-position:center;
        background-attachment:fixed;
        font-family: "Poppins", sans-serif;
  font-weight: 600;
    }
    
    #contain{
        width:100%;
        min-height:500vh;
        height:auto;
        overflow:hidden;
        position:relative;
    }
    
    #cont1{
        width:100%;
        height:auto;
        display:flex;
        flex-wrap:wrap;
        justify-content:space-between;
        float:right;
    }
    
    #cont1_cont1{
        min-height:60vh;
        height:auto;
        margin:70px;
        margin-left:170px;
        width:45%;

        
    }
    
    #cont1_cont1 h1{
        background:#F2E3FA;
        font-size:8rem;
        font-style:italic;
        text-align:center;
        padding:0;
        margin:0;
        padding:5px 10px 5px 10px;
        font-family: "Poppins", sans-serif;
  font-weight: 800;
  width:500px;
  height:auto;
    }
    
    #cont1_cont1 h2{
        background:#EDD0EA;
        width:730px;
        font-size:4.4rem;
        padding:0;
        margin:0;
        text-transform:uppercase;
        font-family: "Playfair Display", serif;
        padding:5px 10px 5px 10px;
    }
    
    #cont1_cont1 p{
        font-size:1.2rem;
        padding:0;
        margin:0;
        margin-top:50px;
        background:#F4F4F4;
        padding:5px 10px 5px 10px;
        font-family: "Poppins", sans-serif;
  font-weight: 600;
    }
    #cont_but{
        display:flex;
        justify-content:space-between;
        width:100%;
        flex-wrap:wrap;
        height:auto;
    }
    
    #cont1_cont1 h3{
        background:#EDD0EA;
        color:black;
        font-size:1.6rem;
        padding:0;
        margin:0;
        width:220px;
        text-align:center;
        margin:20px;
        padding:5px;
        font-style:italic;
        box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;
        transition:.5s all;
        cursor:pointer;

    }
    
    #cont1_cont1 h3:hover{
        transform:scale(1.1);
        transition:.5s all;
    }
    

    
    #cont2{
        float:right;
        width:90%;
        padding-top:10vh;
        min-height:120vh;
        position:relative;
        display:flex;
        justify-content:center;
        align-items:flex-end;
        background-image:url('images/18.png');
        background-size:cover;
        background-position:center;
        padding-bottom:10vh;
        
    }
    

    .image{
        background:lightgrey;
    }
    
    #cont2_cont1{
        width:90%;
    }

    #cont2_flex1{
        width:100%;
        height:auto;
        display:flex;
        flex-wrap:wrap;
        justify-content:center;
    }
    
    #cont2_flex1 h2{
        font-size:4.4rem;
        font-family: "Playfair Display", serif;
        padding:0;
        margin:0;
        background:#EDD6E1;
        width:400px;
        text-align:right;
        padding:5px 15px 5px 15px;
        line-height:1;
        margin:20px;
    }
    #cont2_flex1 p{
        font-size:1.2rem;
        padding:5px 15px 5px 15px;
        margin:0;
        background:#F4F4F4;
        width:300px;
        
        margin:20px;
    }
    
    #cont2_flex1_form1{
        width:500px;
        background-image:url('images/jsp.png');
        background-size:cover;
        background-position:center;
        height:16vh;
        margin:20px;
    }
    
    #cont2_grid1{
        margin-top:20px;
        width:100%;
        display:flex;
        justify-content:center;
        flex-wrap:wrap;
        align-items:center;
    }
    
    #cont2_grid1 img{
        width:500px;
        margin:40px;
    }
    
    #cont3{
        width:95%;
        background-image:url('images/17.png');
        background-size:cover;
        background-position:center;
        float:right;
        display:flex;
        flex-wrap:wrap;
        justify-content:center;
        padding-bottom:10vh;
    }
    
    #cont3 h2{
        background:#9F6B84;
        margin:0;
        padding:0;
        color:white;
        text-transform:uppercase;
        font-family: "Playfair Display", serif;
        display:inline;
        font-size:2.8rem;
        padding:5px 15px 5px 15px;
        margin:40px;
    }
    #cont3_cont1{
        width:90%;
        
        display:flex;
        justify-content:space-between;
        flex-wrap:wrap;
    }
    
    #cont3_cont1_cont1{

        width:400px;
    }
    #cont4{
        position:relative;
        float:right;
        width:95%;
        background-image:url('images/14.png');
        background-size:cover;
        background-position:center;
        padding-bottom:20vh;
    }
    #abso{
        position:absolute;
        right:0;
        top:0px;
        width:350px;
        font-size:3rem;
        font-family: "Playfair Display", serif;
        text-align:right;
        margin:40px;
        background:#7E4C64;
        padding:5px 15px 5px 15px;
        box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;
        color:white;
    }
    
    #cont4 h2{
        background:#C3C3C3;
        margin:50px;
        margin-top:50px;
        font-size:2.8rem;
        font-style:italic;
        width:55%;
        padding:5px 15px 5px 15px;
    }
    
    #cont4 h3{
        background:#C3C3C3;
        margin:50px;
        margin-top:50px;
        font-size:2.8rem;
        font-style:italic;
        width:55%;
        padding:5px 15px 5px 15px;
    }
    
    
    #cont4_cont1{
        width:80%;
        margin-left:50px;
    }
    
    #cont4_cont1 img{
        height:30vh;
    }
    
    #cont4_cont2{
        width:100%;
        margin-left:50px;
    }
    
    #cont4_cont2 img{
        height:40vh;
    }
    
    #cont4 p{
        font-size:1.2rem;
        margin:50px;
        background:#D9D9D9;
        padding:5px 15px 5px 15px;
        width:800px;
    }
    
    
    #haut{
        background:#887978;
        color:white;
        font-size:1.2rem;
        padding:5px 15px 5px 15px;
    }
    
    #bas{
        color:white;
        font-size:1.2rem;
        background:#2c2928;
        padding:5px 15px 5px 15px;
        margin-top:400px;
    }


    



    
    
    
    @media only screen and (min-width: 601px) and (max-width: 1224px) {

    }
    
    @media only screen and  (max-width: 601px){
        #cont1{
            padding-bottom:5vh;
        }
        
        #cont1_cont1{
            margin-left:140px;
        }
        
        #cont1_cont1 h1{
            font-size:4rem;
            width:300px;
         }
        #cont1_cont1 h2{
            width:320px;
            font-size:4.4rem;
        }
        
        #cont1_cont1 p{
            width:320px;
        }
        
        #cont4 h2{
            margin-top:30vh;
            margin-left:100px;
        }
        
        #cont4 h3{
            margin-left:100px;
        }
        
        #cont4_cont1{
            margin-left:100px;
        }
        
        #cont4_cont2{
            margin-left:100px;
        }
        
        #cont4 p{
            width:300px;
            position:relative;
            top:220px;
            margin:80px;
        }
        
        video{
        width:400px;
    }
    
    #bas{
        margin-top:20px;
    }
        

    }
    
    #tshirt{
        position:absolute;
        top:-300px;
        right:40px;
        z-index:999;
        cursor:pointer;

    }
    #tshirt img{
        width:100px;
    }
#boom{
        position:absolute;
        width:200px;
        z-index:1111;
        right:0;
        top:0;
        display:none;
    }
   
    
    
</style>
<body>
    <div id='contain'>
        <?php include 'header.php'; ?>
        <div id='tshirt'>
            <img src='images/shirt.png'>
        </div>
        <img id='boom' src='images/boom.png'>
        <div id='cont1'>
            <div id='cont1_cont1'>
                <h1>Galerie</h1>
                <h2>Meuble à visuels</h2>
                <p>La beauté de la seconde main, c’est que c’est le talent du créateur qui est mis en valeur par ta tenue. Pour t’inspirer, ou voir à travers des mannequins les avantages de la réutilisation, consulte notre galerie ! </p>
                <div id='cont_but'>
                    <h3 class='button1'><a href='#trois'>Tirroirs à affiche</a></h3>
                    <h3 class='button1'><a href='#quatre'>Le spot video</a></h3>
                    <h3 class='button1'><a href='#cinq'>Shooting pics</a></h3>
                </div>
                
            </div>

        </div>
        <div id='cont2'>
            <div id='cont2_cont1'><a id='affiches'></a>
                <div id='cont2_flex1'>
                    <h2>TIROIR A AFFICHES</h2><a id='trois'></a>
                    <p>à partir de ces photos, on a pu réaliser des affiches ! Et toi, tu serais partant pour apparaître sur les visuels ?</p>
                    <div id='cont2_flex1_form1'></div>
                </div>
                <div id='cont2_grid1'>
                    <img src='images/aff1.jpg'>
                    <img src='images/aff2.jpg'>
                </div>
            </div>
        </div>
        <div id='cont3'><a id='video'></a>
            <h2>REAL FASHION NEVER DIES : le film</h2><a id='quatre'></a>
            <div id='cont3_cont1'>
                <div id='cont3_cont1_cont1'>
                    <p id='haut'>Nous avons réalisé une video mettant en avant un nouveau type de consommation textile, tout autant stylé authentique, pour illustrer le message de la campagne</p>
                    <p id='bas'><i>Réalisé par Shanice Toko</i>
                    Tourné par RAMANANTSOA India, RENAULD Jules et TOKO Shanice</p>
                </div>
                <video width="1200" controls>
                    <source src="images/video.mp4" type="video/mp4">
                    Votre navigateur ne supporte pas la balise vidéo.
                </video>
                
            </div>
        </div>
        <div id='cont4'><a id='vintage'></a><a id='cinq'></a>
        <p>La friperie ne t’inspire pas ? Pourtant eux si ! Après s’être postés dans la rue avec des cartons avec des vêtements d’origine diverses, on a demandé à quelques passants de se créer un ou plusieurs outfits stylés avec ce qu’ils trouvaient en 30 secondes ! Avec ça, voici le shooting photo que cela produit : stylé pas vrai ? </p>
            <h1 id='abso'>SHOOTING PHOTO ET MANEQUIN</h1>
            <h2 >porter vos vieux vêtements, ça donne ça : </h2>
            <div id='cont4_cont1'>
                <img src='images/affiche11.png'>
                    <img src='images/affiche2.png'>
                    <img src='images/affiche3.png'>
                    <img src='images/affiche4.png'>
                    <img src='images/affiche5.png'>
                    <img src='images/affiche6.png'>
            </div>
            <h3 >et puis le vieux, c'est joli, c'est tout plein de motifs </h3>
            <div id='cont4_cont2'>
                <img src='images/txt1.jpg'>
                <img src='images/txt2.jpg'>
                <img src='images/txt3.jpg'>
                <img src='images/txt4.jpg'>
                <img src='images/txt5.jpg'>
                <img src='images/txt7.jpg'>
                <img src='images/txt8.jpg'>
                <img src='images/txt9.jpg'>

            </div>
        </div>
        <?php include 'footer.php'; ?>
    </div>
    
</body>
</html>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script>
    let tshirt = document.getElementById('tshirt');
    let boom = document.getElementById('boom');
    let random = Math.floor(Math.random() * (1800 - 0 + 1)) + 0;
    tshirt.style.right = random + 'px';
    let y = 0;
    
    let angle=0;
    
    let restart = true;
    
    
    function rotate() {
        angle = (angle + 0.5) % 360; 
        tshirt.style.transform = `rotate(${angle}deg)`;
        requestAnimationFrame(rotate);
    }

    rotate();
    
    tshirt.addEventListener('click', () => {
        tshirt.style.display='none';
        restart=false;
        const tshirt2 = window.getComputedStyle(tshirt);
        const toptshirt = tshirt2.top;
        const righttshirt = tshirt2.right;
        
        boom.style.display='block';
        boom.style.top = toptshirt;
        boom.style.right = righttshirt;
    });
            
    setInterval(function(){
        if(restart){
            y=y+2;
            
        }
        
        if(!restart){
            y=-300;
            tshirt.style.display='block';
            random = Math.floor(Math.random() * (1800 - 0 + 1)) + 0;
            tshirt.style.right = random + 'px';
            
            setTimeout(function (){
                restart=true;
                boom.style.display ='none';
            },400)
        }
        
        tshirt.style.top = y + 'px';
        
    },10)
    
    setTimeout(function(){
         $('#title_left').css({
            transform: 'translate(0px)'
        });
        $('#title_right').css({
            transform: 'translate(0px)'
        });
    },100)
    
   
</script>